/*****************************************************************************
 * Project: SCT Application Example for LPC11U6x_E6x
 *
 * Implements a start stop event example for the SCT1 
 *
 * For this application the following interface pins are used:
 * -------------------------------------------------------------------------
 * Signal      Port          Signal      
 * -------------------------------------------------------------------------
 * SCT1_OUT0   P2_16         COUNTER_L_RUN
 * SCT1_OUT1   P2_17         COUNTER_H_RUN
 * SCT1_OUT2   P2_18         STATE_1
 * SCT1_OUT3   P2_19         STATE_2
 * ------------------------------------------------------------------------*/
#include "start_stop.h"

int main (void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)            // enable clock for IOCON
                               | (1u << 31);           // enable clock for SCT0/1

    LPC_IOCON->PIO2_16 = 0x00000081;                   // P2_16 is SCT1_OUT0
    LPC_IOCON->PIO2_17 = 0x00000081;                   // P2_17 is SCT1_OUT1
    LPC_IOCON->PIO2_18 = 0x00000081;                   // P2_18 is SCT1_OUT2
    LPC_IOCON->PIO2_19 = 0x00000081;                   // P2_19 is SCT1_OUT3

    start_stop_init();
    
    while (1) 
    {
    }
}


